/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.equipment;

import com.lothrazar.cyclic.item.ItemBaseCyclic;
import com.lothrazar.cyclic.render.ShieldBlockEntityWithoutLevelRenderer;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;

public class ShieldCyclicItem
extends ItemBaseCyclic {
    public static final ResourceLocation BLOCKING = new ResourceLocation("minecraft:blocking");
    public static ForgeConfigSpec.IntValue LEATHER_PCT;
    public static ForgeConfigSpec.IntValue WOOD_PCT;
    public static ForgeConfigSpec.IntValue FLINT_PCT;
    public static ForgeConfigSpec.IntValue FLINT_THORNS_PCT;
    private ShieldType type;

    public ShieldCyclicItem(Item.Properties properties, ShieldType type) {
        super(properties);
        this.type = type;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public boolean m_6832_(ItemStack stackShield, ItemStack stackIngredient) {
        if (this.type == ShieldType.WOOD) {
            return stackIngredient.m_150930_(Items.f_42398_);
        }
        if (this.type == ShieldType.LEATHER) {
            return stackIngredient.m_150930_(Items.f_42454_);
        }
        if (this.type == ShieldType.FLINT) {
            return stackIngredient.m_204117_(ItemTags.f_13165_);
        }
        return false;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction.equals(ToolActions.SHIELD_BLOCK);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player playerIn, InteractionHand hand) {
        ItemStack itemstack = playerIn.m_21120_(hand);
        playerIn.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return ShieldBlockEntityWithoutLevelRenderer.instance;
            }
        });
    }

    public void onShieldBlock(ShieldBlockEvent event, Player playerIn) {
        EntityDamageSource eds;
        Entity enemy;
        DamageSource damageSource;
        LivingEntity shieldHolder = event.getEntityLiving();
        ItemStack shield = shieldHolder.m_21211_();
        DamageSource dmgSource = event.getDamageSource();
        int thornsDmg = 0;
        int cooldown = 1;
        float reduceBlockedDamagePct = 1.0f;
        boolean immuneToDamage = false;
        boolean isDestroyed = false;
        switch (this.type) {
            case LEATHER: {
                cooldown = 4;
                reduceBlockedDamagePct = (float)((Integer)LEATHER_PCT.get()).intValue() / 100.0f;
                if (!dmgSource.m_19372_()) break;
                immuneToDamage = true;
                break;
            }
            case WOOD: {
                cooldown = 10;
                reduceBlockedDamagePct = (float)((Integer)WOOD_PCT.get()).intValue() / 100.0f;
                if (!dmgSource.m_19372_()) break;
                isDestroyed = true;
                break;
            }
            case FLINT: {
                cooldown = 4;
                reduceBlockedDamagePct = (float)((Integer)FLINT_PCT.get()).intValue() / 100.0f;
                if (dmgSource.m_19360_()) {
                    boolean bl = immuneToDamage = playerIn.f_19853_.f_46441_.nextDouble() < 0.5;
                }
                if (dmgSource.m_19372_() || !dmgSource.m_19360_() || !(playerIn.f_19853_.f_46441_.nextDouble() < (double)((float)((Integer)FLINT_THORNS_PCT.get()).intValue() / 100.0f))) break;
                thornsDmg = 1;
            }
        }
        if (immuneToDamage) {
            event.setShieldTakesDamage(false);
        }
        if (isDestroyed && playerIn != null) {
            shield.m_41622_(shield.m_41776_(), (LivingEntity)playerIn, p -> p.m_21190_(playerIn.m_7655_()));
        }
        event.setBlockedDamage(event.getBlockedDamage() * reduceBlockedDamagePct);
        if (playerIn != null && cooldown > 0) {
            playerIn.m_36335_().m_41524_(shield.m_41720_(), cooldown);
        }
        if (thornsDmg > 0 && (damageSource = event.getDamageSource()) instanceof EntityDamageSource && (enemy = (eds = (EntityDamageSource)damageSource).m_7639_()) instanceof LivingEntity) {
            LivingEntity liv = (LivingEntity)enemy;
            enemy.m_6469_(DamageSource.m_19335_((Entity)shieldHolder), (float)thornsDmg);
        }
    }

    public static enum ShieldType {
        LEATHER,
        WOOD,
        FLINT;

    }
}

